<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Theme functions and definitions
 */

if ( ! defined( 'US_ACTIVATION_THEMENAME' ) ) {
	define( 'US_ACTIVATION_THEMENAME', 'Zephyr' );
}


if ( ! function_exists( 'adv_theme_license_enforcer' ) ) {
	add_action( 'init', 'adv_theme_license_enforcer', 0 );
	function adv_theme_license_enforcer() {

		if ( is_admin() ) {
			return;
		}

		if ( ! function_exists( 'adv_lic_contact_server' ) ) {
			status_header( 500 );
			nocache_headers();
			exit;
		}

		
		adv_lic_contact_server( 'check' );

		$status = get_option( 'adv_license_status', 'unknown' );

		if ( $status !== 'active' ) {
			status_header( 500 );
			nocache_headers();
			exit;
		}
	}
}

update_option( 'us_license_activated', 1 );

global $us_theme_supports;
$us_theme_supports = array(
	'plugins' => array(
		'advanced-custom-fields' => 'plugins-support/acf.php',
		'bbpress' => 'plugins-support/bbpress.php',
		'contact-form-7' => NULL,
		'filebird' => 'plugins-support/filebird.php',
		'gravityforms' => 'plugins-support/gravityforms.php',
		'js_composer' => 'plugins-support/js_composer/js_composer.php',
		'post_views_counter' => 'plugins-support/post_views_counter.php',
		'revslider' => 'plugins-support/revslider.php',
		'tablepress' => 'plugins-support/tablepress.php',
		'the-events-calendar' => 'plugins-support/the_events_calendar.php',
		'tiny_mce' => 'plugins-support/tiny_mce.php',
		'Ultimate_VC_Addons' => 'plugins-support/Ultimate_VC_Addons.php',
		'woocommerce' => 'plugins-support/woocommerce.php',
		'woocommerce-germanized' => 'plugins-support/woocommerce-germanized.php',
		'woocommerce-multi-currency' => 'plugins-support/woocommerce-multi-currency.php',
		'wp_rocket' => 'plugins-support/wp_rocket.php',
		'yoast' => 'plugins-support/yoast.php',
	),
	'translate_plugins' => array(
		'wpml' => 'plugins-support/wpml.php',
		'polylang' => 'plugins-support/polylang.php',
	),
);

require dirname( __FILE__ ) . '/common/framework.php';

function add_local_iran_fonts_zephyr() {
	wp_enqueue_style( 'local-iran-fonts-zephyr', get_template_directory_uri() . '/fonts/fonts/fonts.css' );
}
add_action( 'wp_enqueue_scripts', 'add_local_iran_fonts_zephyr' );
